VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 2  'RequiresTransaction
END
Attribute VB_Name = "clsServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

  Enum TableName
    e_Customers = 0
    e_OrderDetails = 1
    e_Orders = 2
    e_Products = 3
    e_Shippers = 4
    e_Employees = 5
    e_Suppliers = 6
  End Enum
  Private Const m_cstrEmployeesAddress As String = "Address"
Private Const m_cstrEmployeesBirthDate As String = "BirthDate"
Private Const m_cstrEmployeesCity As String = "City"
Private Const m_cstrEmployeesCountry As String = "Country"
Private Const m_cstrEmployeesEmployeeID As String = "EmployeeID"
Private Const m_cstrEmployeesExtension As String = "Extension"
Private Const m_cstrEmployeesFirstName As String = "FirstName"
Private Const m_cstrEmployeesHireDate As String = "HireDate"
Private Const m_cstrEmployeesHomePhone As String = "HomePhone"
Private Const m_cstrEmployeesLastName As String = "LastName"
Private Const m_cstrEmployeesNotes As String = "Notes"
Private Const m_cstrEmployeesPhoto As String = "Photo"
Private Const m_cstrEmployeesPostalCode As String = "PostalCode"
Private Const m_cstrEmployeesRegion As String = "Region"
Private Const m_cstrEmployeesReportsTo As String = "ReportsTo"
Private Const m_cstrEmployeesTitle As String = "Title"
Private Const m_cstrEmployeesTitleOfCourtesy As String = "TitleOfCourtesy"
  Private Const m_cstrEmployeesQuery = "Select  [Address] ,  [BirthDate] ,  [City] ,  [Country] ,  [EmployeeID] ,  [Extension] ,  [FirstName] ,  [HireDate] ,  [HomePhone] ,  [LastName] ,  [Notes] ,  [Photo] ,  [PostalCode] ,  [Region] ,  [ReportsTo] ,  [Title] ,  [TitleOfCourtesy]" & _
" From Employees"
    

  Private Const m_cstrCustomersQuery As String = "SELECT * FROM Customers"
  Private Const m_cstrCategoriesQuery As String = "SELECT * FROM " & _
        " Categories"
  Private Const m_cstrShipperQuery As String = "SELECT ShipperID, " & _
        " CompanyName FROM Shippers"
  Private Const m_cstrOrderDetailsProductNameQuery As String = _
        "SELECT Products.ProductName, [Order Details].UnitPrice," _
        & " [Order Details].Quantity, [Order Details].Discount, " & _
        " [Order Details].ProductID, [Order Details].OrderID " _
        & " FROM Products INNER JOIN [Order Details] ON " & _
        " Products.ProductID = [Order Details].ProductID "
  Private Const m_cstrOrderDetailsQuery As String = "SELECT * FROM" & _
        " [Order Details]"
  Private Const m_cstrProductQuery As String = "SELECT ProductID, " & _
        " ProductName, UnitPrice, ReorderLevel, QuantityPerUnit, " & _
        " UnitsInStock, UnitsOnOrder, Discontinued FROM Products "
  Private Const m_cstrOrdersQuery As String = "Select " & _
        "OrderID,CustomerID,EmployeeID,OrderDate,RequiredDate,ShippedDate," _
        & "ShipVia,Freight,ShipName,ShipAddress,ShipCity,ShipRegion, " & _
        " ShipPostalCode,ShipCountry FROM Orders"

  Private Const m_cstrCustomersCustomerIDField As String = "CustomerID"
  Private Const m_cstrOrderDetailsOrderID As String = "OrderID"
  Private Const m_cstrOrderDetailsProductNameField As String = "ProductName"
  Private Const m_cstrProductsUnitsInStockField As String = "UnitsInStock"
  Private Const m_cstrOrderDetailsQuantityField As String = "Quantity"
  Private Const m_cstrOrderDetailsProductIDField As String = "ProductID"
  Private Const m_cstrProductsUnitsOnOrderField As String = "UnitsOnOrder"
  Private Const m_cstrProductsReorderLevelField As String = "ReorderLevel"
  Private Const m_cstrOrderDetailsOrderIDField As String = "OrderID"
  Private Const m_cstrProductsProductIDField As String = "ProductID"

  Private Const m_cstrDatabasePath As String = "C:\Program Files\Microsoft Visual Studio\VB98\Nwind.mdb"
    
  Private m_objADOConnection As ADODB.Connection

  Private m_strErrorDetails As String
  Private m_strQueryString As String
  Private m_objContext As ObjectContext
    
  Implements ObjectControl

Private Sub ObjectControl_Activate()

  Set m_objContext = GetObjectContext
  
End Sub

Private Function ObjectControl_CanBePooled() As Boolean

    ObjectControl_CanBePooled = False
    
End Function

Private Sub ObjectControl_Deactivate()

  Set m_objADOConnection = Nothing
  Set m_objContext = Nothing
  
End Sub

Private Function CreateInstance(ProgID As String) As Object

  On Error GoTo CreateInstanceError

  If Not m_objContext Is Nothing Then
    Set CreateInstance = m_objContext.CreateInstance(ProgID)

  Else

    Select Case ProgID

      Case "ADODB.Connection"
          Set CreateInstance = New ADODB.Connection
        
      Case "ADODB.Recordset"
          Set CreateInstance = New ADODB.Recordset

    End Select

  End If

  Exit Function

CreateInstanceError:

  Err.Raise Err.Number, Err.Source & " CreateInstance", Err.Description

End Function

Public Sub SetComplete()

  If Not m_objContext Is Nothing Then
     m_objContext.SetComplete
  End If

End Sub

Public Sub SetAbort()

  If Not m_objContext Is Nothing Then
    m_objContext.SetAbort
  End If

End Sub

Private Sub SetADOConnection(ByVal v_strUserID As String, _
                ByVal v_strPassword As String)

  On Error GoTo SetADOConnectionError

  Set m_objADOConnection = CreateInstance("ADODB.Connection")

  With m_objADOConnection
     .CursorLocation = adUseClient
     .ConnectionString = "Provider=Microsoft.Jet.OLEDB.3.51;Persist " & _
        "Security Info=False;Data Source=" & m_cstrDatabasePath
    .Open
  End With
   
  Exit Sub

SetADOConnectionError:

  Dim lngErrorCounter As Long
  Dim strErrors As String

  strErrors = Err.Number & ": " & Err.Description

  If m_objADOConnection.Errors.Count > 0 Then

     For lngErrorCounter = 0 To m_objADOConnection.Errors.Count - 1
        strErrors = strErrors & _
        m_objADOConnection.Errors(lngErrorCounter).Number & _
        ": " & m_objADOConnection.Errors(lngErrorCounter).Description & vbCrLf
     Next lngErrorCounter

  End If

  Err.Raise 2000 + vbObjectError, "SetADOConnection " & Err.Source, strErrors

End Sub

Private Function GetADOConnection() As ADODB.Connection

  If m_objADOConnection Is Nothing Then
     Err.Raise 2001, "GetADOConnection", _
        "Trying to Get Connection prior to setting it"

  Else
     Set GetADOConnection = m_objADOConnection

  End If

End Function

Private Sub CloseADOConnection()

  With GetADOConnection

    If .State = adStateOpen Then
       .Close
    End If

  End With

End Sub

Public Function ValidUserIDPassword(ByVal v_strUserID As String, _
    ByVal v_strPassword As String, Optional ByRef r_strErrorDetails As String _
    = "Empty") As Boolean

  On Error GoTo ValidUserIDPasswordError

  SetADOConnection v_strUserID, v_strPassword
  
  ValidUserIDPassword = True

  SetComplete
  
  Exit Function
  
ValidUserIDPasswordError:

  If r_strErrorDetails <> "Empty" Then
    r_strErrorDetails = "Error Details:" & Err.Description & vbCrLf & _
        " Error Number: " & Err.Number & vbCrLf & " Error Source: " & _
        "ValidUserIDPassword " & Err.Source
  End If

  SetAbort
  ValidUserIDPassword = False

End Function

Private Sub GetRecordSet(ByRef r_recRecordset As ADODB.Recordset, _
                    ByVal v_strSource)

  On Error GoTo GetRecordSetError

  Set r_recRecordset = New ADODB.Recordset
  r_recRecordset.CursorLocation = adUseClient
  r_recRecordset.Open _
        v_strSource, GetADOConnection, adOpenStatic, adLockOptimistic
    
  Exit Sub

GetRecordSetError:

  Err.Raise Err.Number, "ReturnRecordSet" & Err.Source, Err.Description

End Sub

Public Function ReturnProductsRecordSet(ByVal v_strUserID As String, ByVal _
    v_strPassword As String, Optional ByVal v_strParameter As String) As _
    ADODB.Recordset

  Dim recProducts As ADODB.Recordset

  On Error GoTo ReturnProductsRecordSetError

  SetADOConnection v_strUserID, v_strPassword
  
  GetRecordSet recProducts, m_cstrProductQuery & v_strParameter
  
  Set ReturnProductsRecordSet = recProducts
 
  Set recProducts.ActiveConnection = Nothing

  SetComplete
  
  CloseADOConnection
  Set recProducts = Nothing

  Exit Function

ReturnProductsRecordSetError:

  CloseADOConnection
  SetAbort

  Err.Raise Err.Number, "ReturnProducts" & " " & Err.Source & " " & _
    m_strErrorDetails

End Function

Public Function ReturnCustomerRecordSet(ByVal v_strUserID As String, ByVal _
        v_strPassword As String, Optional ByVal v_strParameter As String) As _
        ADODB.Recordset

  Dim recCustomers As ADODB.Recordset

  On Error GoTo ReturnCustomerRecordSetError
    
  SetADOConnection v_strUserID, v_strPassword

  GetRecordSet recCustomers, m_cstrCustomersQuery & v_strParameter
    
  Set recCustomers.ActiveConnection = Nothing

  Set ReturnCustomerRecordSet = recCustomers

  SetComplete
  CloseADOConnection
  Set recCustomers = Nothing
  
  Exit Function
        
ReturnCustomerRecordSetError:

  CloseADOConnection
  SetAbort

  Err.Raise Err.Number, "ReturnCustomers" & Err.Source, _
     Err.Description

End Function

Public Function ReturnOrdersRecordSet(ByVal v_strUserID As String, _
    ByVal v_strPassword As String, _
    Optional ByVal v_strParameter As String) As ADODB.Recordset

  Dim recOrders As ADODB.Recordset

  On Error GoTo ReturnOrdersRecordSetError
    
  SetADOConnection v_strUserID, v_strPassword
   
  GetRecordSet recOrders, m_cstrOrdersQuery & v_strParameter
  Set recOrders.ActiveConnection = Nothing
  Set ReturnOrdersRecordSet = recOrders
    
  GetADOConnection.Close
  SetComplete
  Set recOrders = Nothing
    
Exit Function

ReturnOrdersRecordSetError:

  SetAbort
  Err.Raise Err.Number, "ReturnOrders" & " " & Err.Source, _
     m_strErrorDetails

End Function

Public Function ReturnOrderDetailsRecordSet(ByVal v_strUserID As String, _
    ByVal v_strPassword As String, _
    Optional ByVal v_strParameter As String = "Empty") As ADODB.Recordset

  Dim strReturnValue As String
  Dim recOrderDetails As ADODB.Recordset

  On Error GoTo ReturnOrderDetailsRecordSetError
    
  SetADOConnection v_strUserID, v_strPassword
    
  If v_strParameter <> "Empty" Or v_strParameter <> "" Then
        GetRecordSet recOrderDetails, m_cstrOrderDetailsProductNameQuery _
             & " " & v_strParameter
  Else
        GetRecordSet recOrderDetails, m_cstrOrderDetailsProductNameQuery
  End If

  Set recOrderDetails.ActiveConnection = Nothing
  Set ReturnOrderDetailsRecordSet = recOrderDetails
    
  GetADOConnection.Close
  SetComplete
  Set recOrderDetails = Nothing
    
  Exit Function

ReturnOrderDetailsRecordSetError:

  GetADOConnection.Close
  SetAbort
  Err.Raise Err.Number, "ReturnOrderDetails" & " " & Err.Source, _
     m_strErrorDetails

End Function

Public Function UpdateRecordset(ByVal v_strUserID As String, _
           ByVal v_strPassword As String, _
           ByVal v_recClientRecordSet As ADODB.Recordset, _
           ByVal v_eName As TableName, Optional v_strWhereClause As String) As ADODB.Recordset

  On Error GoTo UpdateRecordsetError
    
  SetADOConnection v_strUserID, v_strPassword

  Select Case v_eName

    Case e_Customers
       Set UpdateRecordset = UpdateCustomerRS(v_recClientRecordSet)

    Case e_Products
       Set UpdateRecordset = UpdateProductsRS(v_recClientRecordSet)

    Case e_OrderDetails
       Set UpdateRecordset = UpdateOrderDetailsRS(v_recClientRecordSet)

    Case e_Orders
       Set UpdateRecordset = UpdateOrderRS(v_recClientRecordSet)
    Case e_Employees
       Set UpdateRecordset = UpdateEmployeesRS(v_recClientRecordSet)


  End Select

  SetComplete
  
  CloseADOConnection

  Exit Function

UpdateRecordsetError:

  CloseADOConnection
  SetAbort
 
  m_strErrorDetails = "Error Number: " & Err.Number & " Error " & _
             "Description: " & Err.Description
  Err.Raise Err.Number, "ReturnCustomers" & " " & Err.Source, m_strErrorDetails

End Function

Private Function UpdateCustomerRS(ByVal v_recClientRecordSet As Recordset)

  Dim recCustomers As ADODB.Recordset

  Set recCustomers = v_recClientRecordSet
  Set recCustomers.ActiveConnection = GetADOConnection

  If recCustomers.EditMode = adEditAdd Then

     recCustomers.Update
     
  Else
     On Error Resume Next
     recCustomers.Filter = adFilterPendingRecords
     recCustomers.UpdateBatch adAffectGroup
     recCustomers.Filter = adFilterConflictingRecords
     If recCustomers.RecordCount > 0 Then
          Err.Raise 2009, "UpdateCustomerRS " & Err.Source, _
            "Customer Update Conflict"
     End If

  End If
  
  recCustomers.Filter = adFilterNone
  Set recCustomers.ActiveConnection = Nothing
  Set UpdateCustomerRS = recCustomers
  Set recCustomers = Nothing

End Function

Private Function UpdateProductsRS(ByVal v_recClientRecordSet As _
    ADODB.Recordset) As ADODB.Recordset

  Dim recProducts As ADODB.Recordset
  Dim lngFieldCounter As Long
  
  On Error GoTo UpdateProductsRSError
  
  Set recProducts = CreateInstance("ADODB.Recordset")
  
  If recProducts.EditMode = adEditAdd Then
      With recProducts
          .Source = m_cstrProductQuery & " Where " & _
                 m_cstrProductsProductIDField & "=" & 0
          .ActiveConnection = GetADOConnection
          .LockType = adLockPessimistic
          .CursorLocation = adUseServer
          .CursorType = adOpenKeyset
          .Open
          .AddNew
        For lngFieldCounter = 0 To v_recClientRecordSet.Fields.Count - 1
          If Not IsNull(v_recClientRecordSet.Fields(lngFieldCounter).Value) Then
             .Fields(v_recClientRecordSet.Fields(lngFieldCounter).Name) = _
                v_recClientRecordSet.Fields(lngFieldCounter).Value
          End If
        Next
        .Update
      End With
  Else
    Set recProducts = v_recClientRecordSet
    Set recProducts.ActiveConnection = GetADOConnection
    On Error Resume Next
    recProducts.Filter = adFilterPendingRecords
    recProducts.UpdateBatch adAffectGroup
    recProducts.Filter = adFilterConflictingRecords
        If recProducts.RecordCount > 0 Then
       Dim strReturn
      strReturn = ReconcileProducts(recProducts)
        If strReturn <> "" Then
        Err.Raise 2011, "UpdateProducts " & _
           Err.Source, "Can not reconcile products" & strReturn
        End If
    End If

    recProducts.Filter = adFilterNone

  End If

  Set recProducts.ActiveConnection = Nothing
  Set UpdateProductsRS = recProducts

  CloseADOConnection
  Set recProducts = Nothing
  
  Exit Function
UpdateProductsRSError:

  recProducts.Filter = adFilterNone
  Set recProducts.ActiveConnection = Nothing
  CloseADOConnection

  Err.Raise Err.Number, "Error UpdateProductsRS" & " " & _
     Err.Source, Err.Description

End Function

Private Function ReconcileProducts(ByRef r_recProducts As _
                ADODB.Recordset) As String

  Dim recProducts As New ADODB.Recordset
  Dim strError As String

  On Error GoTo ReconcileProductsError

  Set recProducts = CreateInstance("ADODB.Recordset")
  r_recProducts.Resync adAffectGroup, adResyncUnderlyingValues
  Do Until r_recProducts.EOF
     With recProducts
        .Source = m_cstrProductQuery & " WHERE " & m_cstrProductsProductIDField _
            & "=" & r_recProducts.Fields(m_cstrProductsProductIDField)
        .ActiveConnection = GetADOConnection
        .LockType = adLockPessimistic
        .CursorLocation = adUseServer
        .CursorType = adOpenKeyset
        .Open
      If Not IsNull(r_recProducts.Fields(m_cstrProductsUnitsInStockField).Value) _
        Then
            .Fields(m_cstrProductsUnitsInStockField).Value = _
                  r_recProducts.Fields(m_cstrProductsUnitsInStockField).Value
      End If

      With .Fields(m_cstrProductsUnitsInStockField)
        .Value = _
           r_recProducts.Fields(m_cstrProductsUnitsInStockField).UnderlyingValue _
             + (.Value - _
               recProducts.Fields(m_cstrProductsUnitsInStockField).OriginalValue)
                
      End With
       .UpdateBatch
       .Filter = adFilterConflictingRecords
       If .RecordCount > 0 Then
          strError = strError & .Fields(m_cstrProductsProductIDField)
          .CancelUpdate

       End If
       .Close

    End With
  r_recProducts.MoveNext

  Set recProducts = Nothing

  Loop
  ReconcileProducts = strError

  Exit Function
ReconcileProductsError:

  Err.Raise Err.Number, "Reconcile Products:" & Err.Source, _
     Err.Description & " " & strError

End Function

Private Function UpdateOrderDetailsRS(ByVal v_recClientRecordSet As _
    ADODB.Recordset) As ADODB.Recordset

  Dim recOrderDetails As ADODB.Recordset

  On Error GoTo UpdateOrderDetailsRSError

  Set recOrderDetails = SaveOrderDetailsRS(v_recClientRecordSet)
  With recOrderDetails

     While Not .EOF
         RemoveFromStock .Fields(m_cstrOrderDetailsProductIDField), _
                      .Fields(m_cstrOrderDetailsQuantityField)
         .MoveNext
     Wend

  End With
  recOrderDetails.Close
  Set recOrderDetails.ActiveConnection = Nothing
  Set recOrderDetails = Nothing

  Exit Function
UpdateOrderDetailsRSError:

    Err.Raise Err.Description, "Error UpdateOrderDetailsTable " & _
    Err.Source, Err.Description

End Function
  
Private Function SaveOrderDetailsRS(ByVal v_recClientRecordSet As _
    ADODB.Recordset, Optional ByVal v_lngOrderID As Long = 0) As ADODB.Recordset

  Dim recOrderDetails As New ADODB.Recordset
  Dim lngFieldCounter As Long
  Dim lngRowCounter As Long
  
  Set recOrderDetails = CreateInstance("ADODB.Recordset")

  With recOrderDetails
     .Source = m_cstrOrderDetailsQuery & " Where " & _
         m_cstrOrderDetailsOrderIDField & "=" & 0
     .ActiveConnection = GetADOConnection
     .LockType = adLockPessimistic
     .CursorLocation = adUseServer
     .CursorType = adOpenKeyset
     .Open

     v_recClientRecordSet.MoveFirst 'CAB addition - This line is needed to a multiple line order
     
     Do Until v_recClientRecordSet.EOF
        .AddNew

        For lngFieldCounter = 0 To v_recClientRecordSet.Fields.Count - 1

         If LCase(v_recClientRecordSet.Fields(lngFieldCounter).Name) <> _
           LCase(m_cstrOrderDetailsProductNameField) Then

           If Not IsNull(v_recClientRecordSet.Fields(lngFieldCounter).Value) Then
                .Fields(v_recClientRecordSet.Fields(lngFieldCounter).Name) = _
                     v_recClientRecordSet.Fields(lngFieldCounter).Value
           End If

          End If

        Next

        v_recClientRecordSet.MoveNext
        If v_lngOrderID <> 0 Then
            .Fields(m_cstrOrderDetailsOrderIDField).Value = v_lngOrderID
        End If
       .Update

     Loop

     Set SaveOrderDetailsRS = recOrderDetails

  End With

End Function
  
Private Sub RemoveFromStock(ByVal v_lngProdID As Long, ByVal v_lngQuantity As Long)

  Dim recProducts As ADODB.Recordset

  On Error GoTo RemoveFromStockError

  Set recProducts = CreateInstance("ADODB.Recordset")

  With recProducts
    .Source = m_cstrProductQuery & " Where " & m_cstrProductsProductIDField _
               & "=" & v_lngProdID
    .ActiveConnection = GetADOConnection
    .LockType = adLockPessimistic
    .CursorLocation = adUseClient
    .CursorType = adOpenKeyset
    .Open
  End With
  If recProducts.RecordCount = 0 Then
     Err.Raise 2004, "RemoveFromStock", "Product is not in the database"
  End If
  If recProducts.Fields(m_cstrProductsUnitsInStockField) < v_lngQuantity Then
      Dim intDifference As Integer

    intDifference = v_lngQuantity - _
        recProducts.Fields(m_cstrProductsUnitsInStockField)
    recProducts.Fields(m_cstrProductsUnitsOnOrderField) = _
        recProducts.Fields(m_cstrProductsUnitsOnOrderField) + intDifference
    recProducts.Fields(m_cstrProductsUnitsInStockField) = 0
  Else
    recProducts.Fields(m_cstrProductsUnitsInStockField) = _
        recProducts.Fields(m_cstrProductsUnitsInStockField) - _
        v_lngQuantity
    If recProducts.Fields(m_cstrProductsUnitsInStockField) < _
        recProducts.Fields(m_cstrProductsReorderLevelField) Then
       recProducts.Fields(m_cstrProductsUnitsOnOrderField) = _
            recProducts.Fields(m_cstrProductsUnitsOnOrderField) + _
            v_lngQuantity
    End If

  End If
  recProducts.Update
  Set recProducts = Nothing

  Exit Sub
RemoveFromStockError:

  Err.Raise Err.Number, "RemoveFromStock " & Err.Source, Err.Description

End Sub
    
Private Function UpdateOrderRS(ByVal v_recClientRecordSet As _
                        ADODB.Recordset) As ADODB.Recordset

  Dim recOrder As ADODB.Recordset
  Dim lngFieldCounter As Long
  Dim lngRowCounter As Long

  On Error GoTo UpdateOrderRSError
    '  Set recOrder = v_recClientRecordSet
     ' recOrder.Fields(6).Value = 3
      'App.LogEvent v_recClientRecordSet.Fields(6).Value & (m_objContext Is Nothing)
     ' Exit Function
      
  If v_recClientRecordSet.EditMode = adEditAdd Then
     Set recOrder = CreateInstance("ADODB.Recordset")
    
     With recOrder
       .Source = m_cstrOrdersQuery & " Where " & m_cstrOrderDetailsOrderID & _
                "=" & 0
       .ActiveConnection = GetADOConnection
       .LockType = adLockPessimistic
       .CursorLocation = adUseServer
       .CursorType = adOpenKeyset
       .Open
       .AddNew
       For lngFieldCounter = 0 To v_recClientRecordSet.Fields.Count - 1

         If Not IsNull(v_recClientRecordSet.Fields(lngFieldCounter).Value) Then
            .Fields(v_recClientRecordSet.Fields(lngFieldCounter).Name) _
                = v_recClientRecordSet.Fields(lngFieldCounter).Value
         End If

       Next

      .Update
    End With
 
  Else

    
    Set recOrder.ActiveConnection = GetADOConnection

    On Error Resume Next

    recOrder.Filter = adFilterPendingRecords
    recOrder.UpdateBatch
    recOrder.Filter = adFilterConflictingRecords

    If recOrder.RecordCount > 0 Then
           Err.Raise 2002, "UpdateOrderRS", "Conflicting Errors"
    End If

    recOrder.Filter = adFilterNone

  End If

  Set UpdateOrderRS = recOrder
  Set recOrder = Nothing

  Exit Function

UpdateOrderRSError:

  Err.Raise Err.Description, "Error UpdateOrderRS" & " " & Err.Source, _
        Err.Description

End Function
    
Public Sub SubmitNewOrder(ByVal v_strUserID As String, ByVal v_strPassword As _
  String, ByVal v_recOrders As ADODB.Recordset, ByVal v_recOrderDetails As _
            ADODB.Recordset)
    
  Dim recOrder As ADODB.Recordset
  Dim recOrderDetails As ADODB.Recordset

  On Error GoTo UpdateOrderError

  SetADOConnection v_strUserID, v_strPassword

  Set recOrder = UpdateOrderRS(v_recOrders)

  Set recOrderDetails = SaveOrderDetailsRS(v_recOrderDetails, _
        recOrder.Fields(m_cstrOrderDetailsOrderID))

  With recOrderDetails

     While Not .EOF
       RemoveFromStock .Fields(m_cstrOrderDetailsProductIDField), _
               .Fields(m_cstrOrderDetailsQuantityField)
       .MoveNext
     Wend

  End With
  SetComplete

  CloseADOConnection

  Set recOrder = Nothing
  Set recOrderDetails = Nothing

  Exit Sub
UpdateOrderError:

  CloseADOConnection
  SetAbort

  m_strErrorDetails = "Error Number: " & Err.Number & " Error Description: " _
                    & Err.Description
  Err.Raise Err.Number, "ReturnCustomers" & " " & Err.Source, m_strErrorDetails

End Sub

Private Function UpdateEmployeesRS(ByVal v_recClientRecordSet As _
                        ADODB.Recordset) As ADODB.Recordset
  Dim recEmployees As ADODB.Recordset
  Dim lngFieldCounter As Long
  Dim lngRowCounter As Long
  On Error GoTo UpdateEmployeesRSError
  If v_recClientRecordSet.EditMode = adEditAdd Then
     Set recEmployees = CreateInstance("ADODB.Recordset")
     With recEmployees
       .Source = m_cstrEmployeesQuery & " Where " & m_cstrEmployeesEmployeeID _
                = 0
       .ActiveConnection = GetADOConnection
       .LockType = adLockPessimistic
       .CursorLocation = adUseServer
       .CursorType = adOpenKeyset
       .Open
       .AddNew
       For lngFieldCounter = 0 To v_recClientRecordSet.Fields.Count - 1
         If Not IsNull(v_recClientRecordSet.Fields(lngFieldCounter).Value) Then
            .Fields(v_recClientRecordSet.Fields(lngFieldCounter).Name) _
                = v_recClientRecordSet.Fields(lngFieldCounter).Value
         End If
       Next
      .Update
    End With
  Else
    Set recEmployees = v_recClientRecordSet
    Set recEmployees.ActiveConnection = GetADOConnection
    On Error Resume Next
    recEmployees.Filter = adFilterPendingRecords
    recEmployees.UpdateBatch
    recEmployees.Filter = adFilterConflictingRecords
    If recEmployees.RecordCount > 0 Then
           Err.Raise 2002, "UpdateEmployeesRS", " & Conflicting Errors"
    End If
    recEmployees.Filter = adFilterNone
  End If
  Set UpdateEmployeesRS = recEmployees
  Set recEmployees = Nothing
  Exit Function
UpdateEmployeesRSError:
  Err.Raise Err.Description, " & Error UpdateEmployeesRS" & Err.Source, _
        Err.Description
End Function


